<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class LedgerEntry extends Model
{
    protected $fillable = [
        'transaction_type',
        'reference_type',
        'reference_id',
        'student_id',
        'entry_type',
        'amount',
        'transaction_date',
        'description',
        'receipt_number',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'transaction_date' => 'date',
    ];

    public function student(): BelongsTo
    {
        return $this->belongsTo(Student::class);
    }

    public function reference(): MorphTo
    {
        return $this->morphTo();
    }
}
