<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class StockItem extends Model
{
    protected $fillable = [
        'name',
        'type',
        'quantity',
        'alert_threshold',
        'unit_price',
        'arrival_date',
        'description',
    ];

    protected $casts = [
        'quantity' => 'integer',
        'alert_threshold' => 'integer',
        'unit_price' => 'decimal:2',
        'arrival_date' => 'date',
    ];

    public function bookPurchases(): HasMany
    {
        return $this->hasMany(BookPurchase::class);
    }

    public function uniformPurchases(): HasMany
    {
        return $this->hasMany(UniformPurchase::class);
    }

    // Check if stock is low
    public function isLowStock(): bool
    {
        return $this->quantity <= $this->alert_threshold;
    }

    // Get total sold quantity
    public function getTotalSoldAttribute(): int
    {
        if ($this->type === 'book') {
            return $this->bookPurchases()->sum('quantity');
        } else {
            return $this->uniformPurchases()->sum('quantity');
        }
    }
}
