<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Student extends Model
{
    protected $fillable = [
        'admission_number',
        'name',
        'father_name',
        'admission_date',
        'class',
        'admission_form',
        'monthly_fees',
        'annual_charges',
        'remarks',
    ];

    protected $casts = [
        'admission_date' => 'date',
        'admission_form' => 'decimal:2',
        'monthly_fees' => 'decimal:2',
        'annual_charges' => 'decimal:2',
    ];

    public function feePayments(): HasMany
    {
        return $this->hasMany(FeePayment::class);
    }

    public function bookPurchases(): HasMany
    {
        return $this->hasMany(BookPurchase::class);
    }

    public function uniformPurchases(): HasMany
    {
        return $this->hasMany(UniformPurchase::class);
    }

    public function ledgerEntries(): HasMany
    {
        return $this->hasMany(LedgerEntry::class);
    }

    // Calculate total fees paid
    public function getTotalFeesPaidAttribute(): float
    {
        return $this->feePayments()->sum('amount');
    }

    // Calculate total uniform purchases
    public function getUniformTotalAttribute(): float
    {
        return $this->uniformPurchases()->sum('total_amount');
    }

    // Calculate total book purchases
    public function getBooksCopiesTotalAttribute(): float
    {
        return $this->bookPurchases()->sum('total_amount');
    }

    // Calculate arrears (outstanding fees)
    public function getArrearsAttribute(): float
    {
        $totalDue = $this->admission_form + $this->monthly_fees + $this->annual_charges;
        $totalPaid = $this->total_fees_paid;
        return max(0, $totalDue - $totalPaid);
    }
}
