<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stock_items', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->enum('type', ['book', 'uniform']);
            $table->integer('quantity')->default(0);
            $table->integer('alert_threshold')->default(10); // Alert when stock goes below this
            $table->decimal('unit_price', 10, 2);
            $table->date('arrival_date')->nullable(); // Date when stock arrived
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_items');
    }
};
