<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ledger_entries', function (Blueprint $table) {
            $table->id();
            $table->enum('transaction_type', ['fee_payment', 'book_purchase', 'uniform_purchase', 'expense', 'other']);
            $table->string('reference_type')->nullable(); // Model class name
            $table->unsignedBigInteger('reference_id')->nullable(); // ID of the related record
            $table->foreignId('student_id')->nullable()->constrained()->onDelete('set null');
            $table->enum('entry_type', ['income', 'expense'])->default('income');
            $table->decimal('amount', 10, 2);
            $table->date('transaction_date');
            $table->text('description');
            $table->string('receipt_number')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ledger_entries');
    }
};
