@extends('layouts.app')

@section('title', 'Fee History - The Smart School Education')
@section('page-title', 'Fee Payment History')

@section('content')
<div class="mb-6">
    <h2 class="text-xl font-semibold text-gray-800">Fee Payment History</h2>
</div>

<!-- Filters -->
<div class="bg-white rounded-lg shadow p-4 mb-6">
    <form method="GET" action="{{ route('fees.history') }}" class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <select name="student_id" class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
            <option value="">All Students</option>
            @foreach($students as $student)
            <option value="{{ $student->id }}" {{ request('student_id') == $student->id ? 'selected' : '' }}>
                {{ $student->admission_number }} - {{ $student->name }}
            </option>
            @endforeach
        </select>
        <input type="date" name="from_date" value="{{ request('from_date') }}" 
               placeholder="From Date" 
               class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
        <input type="date" name="to_date" value="{{ request('to_date') }}" 
               placeholder="To Date" 
               class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
        <div class="flex gap-2">
            <button type="submit" class="flex-1 bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                Filter
            </button>
            @if(request()->anyFilled(['student_id', 'from_date', 'to_date']))
            <a href="{{ route('fees.history') }}" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-lg">
                Clear
            </a>
            @endif
        </div>
    </form>
</div>

<!-- Payments Table -->
<div class="bg-white rounded-lg shadow overflow-hidden">
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Fee Type</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Payment Method</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Receipt #</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($payments as $payment)
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3 text-sm text-gray-900">{{ $payment->payment_date->format('d M Y') }}</td>
                    <td class="px-4 py-3 text-sm text-gray-900">
                        {{ $payment->student->admission_number }} - {{ $payment->student->name }}
                    </td>
                    <td class="px-4 py-3 text-sm text-gray-600">{{ $payment->feeType->name ?? 'N/A' }}</td>
                    <td class="px-4 py-3 text-sm text-right font-medium text-green-600">
                        Rs. {{ number_format($payment->amount, 2) }}
                    </td>
                    <td class="px-4 py-3 text-sm text-gray-500">
                        {{ ucfirst(str_replace('_', ' ', $payment->payment_method)) }}
                    </td>
                    <td class="px-4 py-3 text-sm text-gray-500">{{ $payment->receipt_number ?? '-' }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="px-6 py-4 text-center text-sm text-gray-500">
                        No fee payments found.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @if($payments->hasPages())
    <div class="bg-gray-50 px-4 py-3 border-t border-gray-200">
        {{ $payments->links() }}
    </div>
    @endif
</div>
@endsection
