@extends('layouts.app')

@section('title', 'Outstanding Fees - The Smart School Education')
@section('page-title', 'Outstanding Fees')

@section('content')
<div class="mb-6">
    <h2 class="text-xl font-semibold text-gray-800">Students with Outstanding Fees</h2>
    <p class="text-sm text-gray-600">Students who have pending fee payments</p>
</div>

@if($students->count() > 0)
<div class="bg-white rounded-lg shadow overflow-hidden">
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Admission #</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Name</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Class</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Total Due</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Paid</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Outstanding</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @foreach($students as $student)
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3 text-sm font-medium text-gray-900">{{ $student->admission_number }}</td>
                    <td class="px-4 py-3 text-sm text-gray-900">{{ $student->name }}</td>
                    <td class="px-4 py-3 text-sm text-gray-500">{{ $student->class ?? '-' }}</td>
                    <td class="px-4 py-3 text-sm text-right text-gray-600">
                        Rs. {{ number_format($student->admission_form + $student->monthly_fees + $student->annual_charges, 2) }}
                    </td>
                    <td class="px-4 py-3 text-sm text-right text-green-600">
                        Rs. {{ number_format($student->total_fees_paid, 2) }}
                    </td>
                    <td class="px-4 py-3 text-sm text-right font-bold text-red-600">
                        Rs. {{ number_format($student->outstanding_amount, 2) }}
                    </td>
                    <td class="px-4 py-3 text-right text-sm font-medium">
                        <a href="{{ route('fees.collect') }}?student_id={{ $student->id }}" class="text-blue-600 hover:text-blue-900">
                            Collect Fee
                        </a>
                    </td>
                </tr>
                @endforeach
            </tbody>
            <tfoot class="bg-gray-50">
                <tr>
                    <td colspan="5" class="px-4 py-3 text-sm font-bold text-right">Total Outstanding:</td>
                    <td class="px-4 py-3 text-sm font-bold text-right text-red-600">
                        Rs. {{ number_format($students->sum('outstanding_amount'), 2) }}
                    </td>
                    <td></td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
@else
<div class="bg-green-50 border-l-4 border-green-500 p-4">
    <p class="text-sm text-green-700">
        <strong>Great!</strong> No outstanding fees. All students have paid their dues.
    </p>
</div>
@endif
@endsection
