@extends('layouts.app')

@section('title', 'Ledger - The Smart School Education')
@section('page-title', 'Ledger (Hesab Kitab)')

@section('content')
<div class="mb-6">
    <h2 class="text-xl font-semibold text-gray-800">All Financial Transactions</h2>
    <p class="text-sm text-gray-600">Complete record of all income and expenses</p>
</div>

<!-- Filters -->
<div class="bg-white rounded-lg shadow p-4 mb-6">
    <form method="GET" action="{{ route('ledger.index') }}" class="grid grid-cols-1 md:grid-cols-5 gap-4">
        <input type="date" name="from_date" value="{{ request('from_date') }}" 
               placeholder="From Date" 
               class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
        <input type="date" name="to_date" value="{{ request('to_date') }}" 
               placeholder="To Date" 
               class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
        <select name="transaction_type" class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
            <option value="">All Types</option>
            <option value="fee_payment" {{ request('transaction_type') == 'fee_payment' ? 'selected' : '' }}>Fee Payment</option>
            <option value="book_purchase" {{ request('transaction_type') == 'book_purchase' ? 'selected' : '' }}>Book Sale</option>
            <option value="uniform_purchase" {{ request('transaction_type') == 'uniform_purchase' ? 'selected' : '' }}>Uniform Sale</option>
        </select>
        <select name="entry_type" class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
            <option value="">All Entries</option>
            <option value="income" {{ request('entry_type') == 'income' ? 'selected' : '' }}>Income</option>
            <option value="expense" {{ request('entry_type') == 'expense' ? 'selected' : '' }}>Expense</option>
        </select>
        <div class="flex gap-2">
            <button type="submit" class="flex-1 bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                Filter
            </button>
            @if(request()->anyFilled(['from_date', 'to_date', 'transaction_type', 'entry_type']))
            <a href="{{ route('ledger.index') }}" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-lg">
                Clear
            </a>
            @endif
        </div>
    </form>
</div>

<!-- Summary Cards -->
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
    <div class="bg-green-50 border-l-4 border-green-500 p-6 rounded-lg">
        <div class="flex items-center">
            <div class="flex-shrink-0">
                <svg class="h-8 w-8 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            </div>
            <div class="ml-4">
                <p class="text-sm font-medium text-gray-600">Total Income</p>
                <p class="text-2xl font-bold text-green-600">Rs. {{ number_format($totalIncome, 2) }}</p>
            </div>
        </div>
    </div>

    <div class="bg-red-50 border-l-4 border-red-500 p-6 rounded-lg">
        <div class="flex items-center">
            <div class="flex-shrink-0">
                <svg class="h-8 w-8 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                </svg>
            </div>
            <div class="ml-4">
                <p class="text-sm font-medium text-gray-600">Total Expenses</p>
                <p class="text-2xl font-bold text-red-600">Rs. {{ number_format($totalExpense, 2) }}</p>
            </div>
        </div>
    </div>

    <div class="bg-blue-50 border-l-4 border-blue-500 p-6 rounded-lg">
        <div class="flex items-center">
            <div class="flex-shrink-0">
                <svg class="h-8 w-8 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 7h6m0 10v-3m-3 3h.01M9 17h.01M9 14h.01M12 14h.01M15 11h.01M12 11h.01M9 11h.01M7 21h10a2 2 0 002-2V5a2 2 0 00-2-2H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                </svg>
            </div>
            <div class="ml-4">
                <p class="text-sm font-medium text-gray-600">Net Balance</p>
                <p class="text-2xl font-bold {{ $netBalance >= 0 ? 'text-blue-600' : 'text-red-600' }}">
                    Rs. {{ number_format($netBalance, 2) }}
                </p>
            </div>
        </div>
    </div>
</div>

<!-- Ledger Table -->
<div class="bg-white rounded-lg shadow overflow-hidden">
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Description</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Income</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Expense</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Receipt</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($ledgerEntries as $entry)
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3 text-sm text-gray-900">{{ $entry->transaction_date->format('d M Y') }}</td>
                    <td class="px-4 py-3 text-sm">
                        <span class="px-2 py-1 text-xs rounded-full 
                            {{ $entry->transaction_type == 'fee_payment' ? 'bg-blue-100 text-blue-800' : 
                               ($entry->transaction_type == 'book_purchase' ? 'bg-green-100 text-green-800' : 'bg-purple-100 text-purple-800') }}">
                            {{ ucfirst(str_replace('_', ' ', $entry->transaction_type)) }}
                        </span>
                    </td>
                    <td class="px-4 py-3 text-sm text-gray-900">
                        @if($entry->student)
                            {{ $entry->student->admission_number }} - {{ $entry->student->name }}
                        @else
                            -
                        @endif
                    </td>
                    <td class="px-4 py-3 text-sm text-gray-600">{{ $entry->description }}</td>
                    <td class="px-4 py-3 text-sm text-right font-medium text-green-600">
                        @if($entry->entry_type == 'income')
                            Rs. {{ number_format($entry->amount, 2) }}
                        @else
                            -
                        @endif
                    </td>
                    <td class="px-4 py-3 text-sm text-right font-medium text-red-600">
                        @if($entry->entry_type == 'expense')
                            Rs. {{ number_format($entry->amount, 2) }}
                        @else
                            -
                        @endif
                    </td>
                    <td class="px-4 py-3 text-sm text-gray-500">{{ $entry->receipt_number ?? '-' }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="px-6 py-4 text-center text-sm text-gray-500">
                        No transactions found.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @if($ledgerEntries->hasPages())
    <div class="bg-gray-50 px-4 py-3 border-t border-gray-200">
        {{ $ledgerEntries->links() }}
    </div>
    @endif
</div>
@endsection
