@extends('layouts.app')

@section('title', 'Financial Reports - The Smart School Education')
@section('page-title', 'Financial Reports')

@section('content')
<div class="mb-6">
    <h2 class="text-xl font-semibold text-gray-800">Financial Reports & Analysis</h2>
    <p class="text-sm text-gray-600">Comprehensive financial overview and statistics</p>
</div>

<!-- Date Range Filter -->
<div class="bg-white rounded-lg shadow p-4 mb-6">
    <form method="GET" action="{{ route('ledger.reports') }}" class="flex flex-col sm:flex-row gap-4 sm:items-end">
        <div class="flex-1 w-full">
            <label class="block text-sm font-medium text-gray-700 mb-2">From Date</label>
            <input type="date" name="from_date" value="{{ $fromDate }}" 
                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 text-sm sm:text-base">
        </div>
        <div class="flex-1 w-full">
            <label class="block text-sm font-medium text-gray-700 mb-2">To Date</label>
            <input type="date" name="to_date" value="{{ $toDate }}" 
                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 text-sm sm:text-base">
        </div>
        <div class="flex gap-2 sm:flex-col sm:gap-0 w-full sm:w-auto">
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 sm:px-6 py-2 rounded-lg text-sm sm:text-base flex-1 sm:flex-none">
                Generate Report
            </button>
            <a href="{{ route('ledger.reports') }}" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 sm:px-6 py-2 rounded-lg inline-block text-sm sm:text-base text-center flex-1 sm:flex-none">
                Reset
            </a>
        </div>
    </form>
</div>

<!-- Summary Cards -->
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-6 mb-6">
    <div class="bg-green-50 border-l-4 border-green-500 p-6 rounded-lg">
        <div class="flex items-center">
            <div class="flex-shrink-0">
                <svg class="h-8 w-8 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            </div>
            <div class="ml-4">
                <p class="text-sm font-medium text-gray-600">Total Income</p>
                <p class="text-2xl font-bold text-green-600">Rs. {{ number_format($totalIncome, 2) }}</p>
            </div>
        </div>
    </div>

    <div class="bg-red-50 border-l-4 border-red-500 p-6 rounded-lg">
        <div class="flex items-center">
            <div class="flex-shrink-0">
                <svg class="h-8 w-8 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                </svg>
            </div>
            <div class="ml-4">
                <p class="text-sm font-medium text-gray-600">Total Expenses</p>
                <p class="text-2xl font-bold text-red-600">Rs. {{ number_format($totalExpense, 2) }}</p>
            </div>
        </div>
    </div>

    <div class="bg-blue-50 border-l-4 border-blue-500 p-6 rounded-lg">
        <div class="flex items-center">
            <div class="flex-shrink-0">
                <svg class="h-8 w-8 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 7h6m0 10v-3m-3 3h.01M9 17h.01M9 14h.01M12 14h.01M15 11h.01M12 11h.01M9 11h.01M7 21h10a2 2 0 002-2V5a2 2 0 00-2-2H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                </svg>
            </div>
            <div class="ml-4">
                <p class="text-sm font-medium text-gray-600">Net Balance</p>
                <p class="text-2xl font-bold {{ $netBalance >= 0 ? 'text-blue-600' : 'text-red-600' }}">
                    Rs. {{ number_format($netBalance, 2) }}
                </p>
            </div>
        </div>
    </div>

    <div class="bg-purple-50 border-l-4 border-purple-500 p-6 rounded-lg">
        <div class="flex items-center">
            <div class="flex-shrink-0">
                <svg class="h-8 w-8 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                </svg>
            </div>
            <div class="ml-4">
                <p class="text-sm font-medium text-gray-600">Profit Margin</p>
                <p class="text-2xl font-bold text-purple-600">
                    {{ $totalIncome > 0 ? number_format(($netBalance / $totalIncome) * 100, 1) : 0 }}%
                </p>
            </div>
        </div>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
    <!-- Income Breakdown -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Income Breakdown</h3>
        <div class="space-y-4">
            <div>
                <div class="flex justify-between mb-2">
                    <span class="text-sm font-medium text-gray-700">Fee Payments</span>
                    <span class="text-sm font-bold text-green-600">Rs. {{ number_format($feeCollection, 2) }}</span>
                </div>
                <div class="w-full bg-gray-200 rounded-full h-2">
                    <div class="bg-green-500 h-2 rounded-full" style="width: {{ $totalIncome > 0 ? ($feeCollection / $totalIncome) * 100 : 0 }}%"></div>
                </div>
            </div>
            <div>
                <div class="flex justify-between mb-2">
                    <span class="text-sm font-medium text-gray-700">Book Sales</span>
                    <span class="text-sm font-bold text-green-600">Rs. {{ number_format($bookSales, 2) }}</span>
                </div>
                <div class="w-full bg-gray-200 rounded-full h-2">
                    <div class="bg-blue-500 h-2 rounded-full" style="width: {{ $totalIncome > 0 ? ($bookSales / $totalIncome) * 100 : 0 }}%"></div>
                </div>
            </div>
            <div>
                <div class="flex justify-between mb-2">
                    <span class="text-sm font-medium text-gray-700">Uniform Sales</span>
                    <span class="text-sm font-bold text-green-600">Rs. {{ number_format($uniformSales, 2) }}</span>
                </div>
                <div class="w-full bg-gray-200 rounded-full h-2">
                    <div class="bg-purple-500 h-2 rounded-full" style="width: {{ $totalIncome > 0 ? ($uniformSales / $totalIncome) * 100 : 0 }}%"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Sales Comparison -->
    <div class="bg-white rounded-lg shadow p-4 sm:p-6">
        <h3 class="text-base sm:text-lg font-semibold text-gray-900 mb-4">Sales Comparison</h3>
        <div class="space-y-6">
            <div>
                <div class="flex justify-between items-center mb-2">
                    <span class="text-sm font-medium text-gray-700">Books</span>
                    <span class="text-lg font-bold text-blue-600">Rs. {{ number_format($bookSales, 2) }}</span>
                </div>
                <div class="w-full bg-gray-200 rounded-full h-4">
                    @php
                        $totalSales = $bookSales + $uniformSales;
                        $bookPercentage = $totalSales > 0 ? ($bookSales / $totalSales) * 100 : 0;
                    @endphp
                    <div class="bg-blue-500 h-4 rounded-full" style="width: {{ $bookPercentage }}%"></div>
                </div>
            </div>
            <div>
                <div class="flex justify-between items-center mb-2">
                    <span class="text-sm font-medium text-gray-700">Uniforms</span>
                    <span class="text-lg font-bold text-purple-600">Rs. {{ number_format($uniformSales, 2) }}</span>
                </div>
                <div class="w-full bg-gray-200 rounded-full h-4">
                    @php
                        $uniformPercentage = $totalSales > 0 ? ($uniformSales / $totalSales) * 100 : 0;
                    @endphp
                    <div class="bg-purple-500 h-4 rounded-full" style="width: {{ $uniformPercentage }}%"></div>
                </div>
            </div>
            <div class="pt-4 border-t border-gray-200">
                <div class="flex justify-between items-center">
                    <span class="text-base font-semibold text-gray-900">Total Sales</span>
                    <span class="text-xl font-bold text-green-600">Rs. {{ number_format($totalSales, 2) }}</span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Monthly Trend -->
<div class="bg-white rounded-lg shadow p-6 mb-6">
    <h3 class="text-lg font-semibold text-gray-900 mb-4">Monthly Income & Expense Trend (Last 12 Months)</h3>
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Month</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Income</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Expense</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Net</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($monthlyData as $month)
                @php
                    $monthNet = $month->income - $month->expense;
                    $monthName = \Carbon\Carbon::createFromFormat('Y-m', $month->month)->format('M Y');
                @endphp
                <tr>
                    <td class="px-4 py-3 text-sm font-medium text-gray-900">{{ $monthName }}</td>
                    <td class="px-4 py-3 text-sm text-right text-green-600">Rs. {{ number_format($month->income, 2) }}</td>
                    <td class="px-4 py-3 text-sm text-right text-red-600">Rs. {{ number_format($month->expense, 2) }}</td>
                    <td class="px-4 py-3 text-sm text-right font-medium {{ $monthNet >= 0 ? 'text-blue-600' : 'text-red-600' }}">
                        Rs. {{ number_format($monthNet, 2) }}
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="4" class="px-6 py-4 text-center text-sm text-gray-500">No data available</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

<!-- Top Students -->
@if($topStudents->count() > 0)
<div class="bg-white rounded-lg shadow p-6 mb-6">
    <h3 class="text-lg font-semibold text-gray-900 mb-4">Top 10 Students by Payment</h3>
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Rank</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Admission #</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student Name</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Total Paid</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @foreach($topStudents as $index => $entry)
                <tr>
                    <td class="px-4 py-3 text-sm font-medium text-gray-900">#{{ $index + 1 }}</td>
                    <td class="px-4 py-3 text-sm text-gray-600">{{ $entry->student->admission_number ?? 'N/A' }}</td>
                    <td class="px-4 py-3 text-sm text-gray-900">{{ $entry->student->name ?? 'N/A' }}</td>
                    <td class="px-4 py-3 text-sm text-right font-bold text-green-600">Rs. {{ number_format($entry->total, 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endif

<!-- Transaction Summary Table -->
<div class="bg-white rounded-lg shadow p-6">
    <h3 class="text-lg font-semibold text-gray-900 mb-4">Transaction Type Summary</h3>
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <h4 class="text-md font-semibold text-green-700 mb-3">Income Sources</h4>
            <div class="space-y-2">
                @forelse($incomeByType as $type => $amount)
                <div class="flex justify-between items-center p-3 bg-green-50 rounded-lg">
                    <span class="text-sm font-medium text-gray-700">{{ ucfirst(str_replace('_', ' ', $type)) }}</span>
                    <span class="text-sm font-bold text-green-600">Rs. {{ number_format($amount, 2) }}</span>
                </div>
                @empty
                <p class="text-sm text-gray-500">No income transactions</p>
                @endforelse
            </div>
        </div>
        <div>
            <h4 class="text-md font-semibold text-red-700 mb-3">Expense Categories</h4>
            <div class="space-y-2">
                @forelse($expenseByType as $type => $amount)
                <div class="flex justify-between items-center p-3 bg-red-50 rounded-lg">
                    <span class="text-sm font-medium text-gray-700">{{ ucfirst(str_replace('_', ' ', $type)) }}</span>
                    <span class="text-sm font-bold text-red-600">Rs. {{ number_format($amount, 2) }}</span>
                </div>
                @empty
                <p class="text-sm text-gray-500">No expense transactions</p>
                @endforelse
            </div>
        </div>
    </div>
</div>

<!-- Print Button -->
<div class="mt-6 flex justify-end">
    <button onclick="window.print()" class="bg-gray-600 hover:bg-gray-700 text-white px-6 py-2 rounded-lg flex items-center">
        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
        </svg>
        Print Report
    </button>
</div>

<style>
@media print {
    .no-print {
        display: none;
    }
}
</style>
@endsection
