@extends('layouts.app')

@section('title', 'Add Stock - The Smart School Education')
@section('page-title', 'Add Stock Item')

@section('content')
<div class="bg-white rounded-lg shadow p-6">
    <form action="{{ route('stock.store') }}" method="POST">
        @csrf

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Name -->
            <div>
                <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Item Name *</label>
                <input type="text" name="name" id="name" value="{{ old('name') }}" required
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 @error('name') border-red-500 @enderror">
                @error('name')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Type -->
            <div>
                <label for="type" class="block text-sm font-medium text-gray-700 mb-2">Type *</label>
                <select name="type" id="type" required
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 @error('type') border-red-500 @enderror">
                    <option value="">Select Type</option>
                    <option value="book" {{ old('type') == 'book' ? 'selected' : '' }}>Book</option>
                    <option value="uniform" {{ old('type') == 'uniform' ? 'selected' : '' }}>Uniform</option>
                </select>
                @error('type')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Quantity -->
            <div>
                <label for="quantity" class="block text-sm font-medium text-gray-700 mb-2">Quantity *</label>
                <input type="number" name="quantity" id="quantity" value="{{ old('quantity', 0) }}" min="0" required
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 @error('quantity') border-red-500 @enderror">
                @error('quantity')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Alert Threshold -->
            <div>
                <label for="alert_threshold" class="block text-sm font-medium text-gray-700 mb-2">Alert Threshold *</label>
                <input type="number" name="alert_threshold" id="alert_threshold" value="{{ old('alert_threshold', 10) }}" min="0" required
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 @error('alert_threshold') border-red-500 @enderror">
                <p class="mt-1 text-xs text-gray-500">Alert when stock goes below this number</p>
                @error('alert_threshold')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Unit Price -->
            <div>
                <label for="unit_price" class="block text-sm font-medium text-gray-700 mb-2">Unit Price (Rs.) *</label>
                <input type="number" name="unit_price" id="unit_price" value="{{ old('unit_price', 0) }}" step="0.01" min="0" required
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 @error('unit_price') border-red-500 @enderror">
                @error('unit_price')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Arrival Date -->
            <div>
                <label for="arrival_date" class="block text-sm font-medium text-gray-700 mb-2">Arrival Date</label>
                <input type="date" name="arrival_date" id="arrival_date" value="{{ old('arrival_date', date('Y-m-d')) }}"
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
            </div>
        </div>

        <!-- Description -->
        <div class="mt-6">
            <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description</label>
            <textarea name="description" id="description" rows="3"
                      class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">{{ old('description') }}</textarea>
        </div>

        <!-- Buttons -->
        <div class="mt-6 flex justify-end gap-4">
            <a href="{{ route('stock.index') }}" class="px-6 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50">
                Cancel
            </a>
            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                Save Stock Item
            </button>
        </div>
    </form>
</div>
@endsection
