<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Students List - The Smart School Education</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        @media print {
            @page {
                size: A4;
                margin: 8mm;
            }
            body {
                margin: 0;
                padding: 0;
            }
            .no-print {
                display: none !important;
            }
        }
        body {
            font-family: 'Arial', 'Helvetica', sans-serif;
            font-size: 11px;
            line-height: 1.4;
            margin: 0;
            padding: 15px;
            color: #000;
        }
        .header {
            text-align: center;
            margin-bottom: 15px;
            border-bottom: 3px solid #000;
            padding-bottom: 12px;
        }
        .header h1 {
            margin: 0;
            font-size: 22px;
            font-weight: bold;
            letter-spacing: 1px;
            color: #000;
        }
        .header p {
            margin: 4px 0;
            font-size: 13px;
            font-weight: 500;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 12px;
            font-size: 10px;
        }
        th, td {
            border: 1px solid #000;
            padding: 6px 4px;
            text-align: left;
        }
        th {
            background-color: #e8e8e8;
            font-weight: bold;
            text-align: center;
            font-size: 10px;
            padding: 8px 4px;
        }
        td {
            text-align: left;
            font-size: 9px;
            padding: 5px 4px;
        }
        tbody tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .text-right {
            text-align: right;
            font-weight: 500;
        }
        .text-center {
            text-align: center;
        }
        .footer {
            margin-top: 20px;
            padding-top: 10px;
            border-top: 2px solid #000;
            text-align: center;
            font-size: 10px;
            font-weight: 500;
        }
        .summary {
            margin-top: 15px;
            padding: 12px;
            border: 2px solid #000;
            background-color: #f5f5f5;
        }
        .summary-row {
            display: flex;
            justify-content: space-between;
            padding: 6px 0;
            font-size: 11px;
            border-bottom: 1px dotted #666;
        }
        .summary-row:last-child {
            border-bottom: none;
            font-weight: bold;
            font-size: 13px;
            margin-top: 8px;
            padding-top: 10px;
            border-top: 2px solid #000;
        }
        .print-btn {
            text-align: center;
            margin: 20px 0;
        }
        .print-btn button {
            background-color: #4CAF50;
            color: white;
            padding: 12px 35px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            font-family: 'Arial', sans-serif;
        }
        .print-btn button:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>
    <div class="print-btn no-print">
        <button onclick="window.print()">🖨️ Print</button>
    </div>

    <div class="header">
        <h1>THE SMART SCHOOL EDUCATION</h1>
        <p>Students List</p>
        <p>Date: {{ date('d M Y, h:i A') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 3%;">S.No</th>
                <th style="width: 12%;">Name</th>
                <th style="width: 10%;">Father</th>
                <th style="width: 6%;">Class</th>
                <th style="width: 8%;">Admission Form</th>
                <th style="width: 8%;">Monthly Fees</th>
                <th style="width: 8%;">Annual Charges</th>
                <th style="width: 7%;">Uniform</th>
                <th style="width: 8%;">Books/Copies</th>
                <th style="width: 8%;">Arrears</th>
                <th style="width: 12%;">Remarks</th>
            </tr>
        </thead>
        <tbody>
            @foreach($students as $index => $student)
            <tr>
                <td class="text-center">{{ $index + 1 }}</td>
                <td>{{ $student->name }}</td>
                <td>{{ $student->father_name ?? '-' }}</td>
                <td class="text-center">{{ $student->class ?? '-' }}</td>
                <td class="text-right">{{ number_format($student->admission_form, 2) }}</td>
                <td class="text-right">{{ number_format($student->monthly_fees, 2) }}</td>
                <td class="text-right">{{ number_format($student->annual_charges, 2) }}</td>
                <td class="text-right">{{ number_format($student->uniform_total, 2) }}</td>
                <td class="text-right">{{ number_format($student->books_copies_total, 2) }}</td>
                <td class="text-right">{{ number_format($student->arrears, 2) }}</td>
                <td>{{ $student->remarks ?? '-' }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="summary">
        <div class="summary-row">
            <strong>Total Students:</strong>
            <strong>{{ $students->count() }}</strong>
        </div>
        <div class="summary-row">
            <strong>Total Admission Form:</strong>
            <strong>Rs. {{ number_format($students->sum('admission_form'), 2) }}</strong>
        </div>
        <div class="summary-row">
            <strong>Total Monthly Fees:</strong>
            <strong>Rs. {{ number_format($students->sum('monthly_fees'), 2) }}</strong>
        </div>
        <div class="summary-row">
            <strong>Total Annual Charges:</strong>
            <strong>Rs. {{ number_format($students->sum('annual_charges'), 2) }}</strong>
        </div>
        <div class="summary-row">
            <strong>Total Arrears:</strong>
            <strong>Rs. {{ number_format($students->sum('arrears'), 2) }}</strong>
        </div>
    </div>

    <div class="footer">
        <p>Generated on {{ date('d M Y, h:i A') }} | The Smart School Education</p>
    </div>

    <script>
        // Auto print is disabled - user can click print button
        // window.onload = function() {
        //     window.print();
        // }
    </script>
</body>
</html>

