@extends('layouts.app')

@section('title', 'Student Details - The Smart School Education')
@section('page-title', 'Student Details')

@section('content')
<div class="mb-6">
    <a href="{{ route('students.index') }}" class="text-blue-600 hover:text-blue-800 flex items-center">
        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
        </svg>
        Back to Students
    </a>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Student Information -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex justify-between items-start mb-6">
                <div>
                    <h2 class="text-2xl font-bold text-gray-900">{{ $student->name }}</h2>
                    <p class="text-gray-600">Admission #: {{ $student->admission_number }}</p>
                </div>
                <div class="flex gap-2">
                    <a href="{{ route('students.edit', $student) }}" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">
                        Edit
                    </a>
                    <form action="{{ route('students.destroy', $student) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this student?');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg">
                            Delete
                        </button>
                    </form>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="text-sm font-medium text-gray-500">Father's Name</label>
                    <p class="text-gray-900">{{ $student->father_name ?? '-' }}</p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Mother's Name</label>
                    <p class="text-gray-900">{{ $student->mother_name ?? '-' }}</p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Admission Date</label>
                    <p class="text-gray-900">{{ $student->admission_date->format('d M Y') }}</p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Date of Birth</label>
                    <p class="text-gray-900">{{ $student->date_of_birth ? $student->date_of_birth->format('d M Y') : '-' }}</p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Class</label>
                    <p class="text-gray-900">
                        @if($student->class)
                            {{ $student->class }}@if($student->section) - {{ $student->section }}@endif
                        @else
                            -
                        @endif
                    </p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Gender</label>
                    <p class="text-gray-900">{{ ucfirst($student->gender ?? '-') }}</p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Phone</label>
                    <p class="text-gray-900">{{ $student->phone ?? '-' }}</p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Email</label>
                    <p class="text-gray-900">{{ $student->email ?? '-' }}</p>
                </div>
                <div class="md:col-span-2">
                    <label class="text-sm font-medium text-gray-500">Address</label>
                    <p class="text-gray-900">{{ $student->address ?? '-' }}</p>
                </div>
            </div>
        </div>

        <!-- Fee Summary Card -->
        <div class="bg-white rounded-lg shadow p-6 mt-6">
            <h3 class="text-lg font-semibold mb-4">Fee Summary</h3>
            @php
                $totalDue = $student->admission_form + $student->monthly_fees + $student->annual_charges;
                $totalPaid = $student->total_fees_paid;
                $remaining = $student->arrears;
            @endphp
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded-lg">
                    <p class="text-sm font-medium text-gray-600 mb-1">Total Fees Due</p>
                    <p class="text-2xl font-bold text-blue-600">Rs. {{ number_format($totalDue, 2) }}</p>
                    <p class="text-xs text-gray-500 mt-1">
                        Form: Rs. {{ number_format($student->admission_form, 2) }}<br>
                        Monthly: Rs. {{ number_format($student->monthly_fees, 2) }}<br>
                        Annual: Rs. {{ number_format($student->annual_charges, 2) }}
                    </p>
                </div>
                <div class="bg-green-50 border-l-4 border-green-500 p-4 rounded-lg">
                    <p class="text-sm font-medium text-gray-600 mb-1">Total Paid</p>
                    <p class="text-2xl font-bold text-green-600">Rs. {{ number_format($totalPaid, 2) }}</p>
                    <p class="text-xs text-gray-500 mt-1">
                        {{ $student->feePayments->count() }} payment(s) received
                    </p>
                </div>
                <div class="bg-red-50 border-l-4 {{ $remaining > 0 ? 'border-red-500' : 'border-green-500' }} p-4 rounded-lg">
                    <p class="text-sm font-medium text-gray-600 mb-1">Remaining</p>
                    <p class="text-2xl font-bold {{ $remaining > 0 ? 'text-red-600' : 'text-green-600' }}">
                        Rs. {{ number_format($remaining, 2) }}
                    </p>
                    <p class="text-xs {{ $remaining > 0 ? 'text-red-600' : 'text-green-600' }} mt-1 font-medium">
                        @if($remaining > 0)
                            ⚠️ Payment Pending
                        @else
                            ✅ Fully Paid
                        @endif
                    </p>
                </div>
            </div>
            
            @if($remaining > 0)
            <div class="mb-4">
                <a href="{{ route('fees.collect') }}?student_id={{ $student->id }}" class="inline-flex items-center px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    Collect Fee Payment
                </a>
            </div>
            @endif
        </div>

        <!-- Fee Payments -->
        <div class="bg-white rounded-lg shadow p-6 mt-6">
            <h3 class="text-lg font-semibold mb-4">Payment History</h3>
            @if($student->feePayments->count() > 0)
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Fee Type</th>
                            <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Payment Method</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Receipt #</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($student->feePayments->sortByDesc('payment_date') as $payment)
                        <tr>
                            <td class="px-4 py-3 text-sm">{{ $payment->payment_date->format('d M Y') }}</td>
                            <td class="px-4 py-3 text-sm">{{ $payment->feeType->name ?? 'N/A' }}</td>
                            <td class="px-4 py-3 text-sm font-medium text-green-600 text-right">Rs. {{ number_format($payment->amount, 2) }}</td>
                            <td class="px-4 py-3 text-sm text-gray-500">{{ ucfirst(str_replace('_', ' ', $payment->payment_method ?? '-')) }}</td>
                            <td class="px-4 py-3 text-sm text-gray-500">{{ $payment->receipt_number ?? '-' }}</td>
                        </tr>
                        @endforeach
                        <tr class="bg-gray-50 font-bold">
                            <td colspan="2" class="px-4 py-3 text-sm">Total Paid</td>
                            <td class="px-4 py-3 text-sm text-green-600 text-right">Rs. {{ number_format($totalPaid, 2) }}</td>
                            <td colspan="2"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            @else
            <div class="text-center py-8">
                <p class="text-gray-500 text-sm mb-4">No fee payments recorded yet.</p>
                <a href="{{ route('fees.collect') }}?student_id={{ $student->id }}" class="inline-flex items-center px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    Collect First Payment
                </a>
            </div>
            @endif
        </div>
    </div>

    <!-- Sidebar Stats -->
    <div class="space-y-6">
        <!-- Quick Summary Card -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold mb-4">Quick Summary</h3>
            <div class="space-y-4">
                @php
                    $totalDue = $student->admission_form + $student->monthly_fees + $student->annual_charges;
                    $totalPaid = $student->total_fees_paid;
                    $remaining = $student->arrears;
                @endphp
                <div class="border-b pb-3">
                    <label class="text-sm font-medium text-gray-500">Total Fees Due</label>
                    <p class="text-xl font-bold text-gray-900">Rs. {{ number_format($totalDue, 2) }}</p>
                </div>
                <div class="border-b pb-3">
                    <label class="text-sm font-medium text-gray-500">Total Paid</label>
                    <p class="text-xl font-bold text-green-600">Rs. {{ number_format($totalPaid, 2) }}</p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Remaining</label>
                    <p class="text-xl font-bold {{ $remaining > 0 ? 'text-red-600' : 'text-green-600' }}">
                        Rs. {{ number_format($remaining, 2) }}
                    </p>
                    @if($remaining > 0)
                    <p class="text-xs text-red-600 mt-1">⚠️ Payment Pending</p>
                    @else
                    <p class="text-xs text-green-600 mt-1">✅ Fully Paid</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Book Purchases -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold mb-4">Book Purchases</h3>
            @if($student->bookPurchases->count() > 0)
            <div class="space-y-2">
                @foreach($student->bookPurchases->take(5) as $purchase)
                <div class="text-sm">
                    <p class="font-medium">{{ $purchase->stockItem->name }}</p>
                    <p class="text-gray-600">Qty: {{ $purchase->quantity }} × Rs. {{ number_format($purchase->unit_price, 2) }}</p>
                    <p class="text-gray-500 text-xs">{{ $purchase->purchase_date->format('d M Y') }}</p>
                </div>
                @endforeach
            </div>
            @else
            <p class="text-gray-500 text-sm">No book purchases yet.</p>
            @endif
        </div>

        <!-- Uniform Purchases -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold mb-4">Uniform Purchases</h3>
            @if($student->uniformPurchases->count() > 0)
            <div class="space-y-2">
                @foreach($student->uniformPurchases->take(5) as $purchase)
                <div class="text-sm">
                    <p class="font-medium">{{ $purchase->stockItem->name }}</p>
                    <p class="text-gray-600">Qty: {{ $purchase->quantity }} × Rs. {{ number_format($purchase->unit_price, 2) }}</p>
                    <p class="text-gray-500 text-xs">{{ $purchase->purchase_date->format('d M Y') }}</p>
                </div>
                @endforeach
            </div>
            @else
            <p class="text-gray-500 text-sm">No uniform purchases yet.</p>
            @endif
        </div>
    </div>
</div>
@endsection

