<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\StudentController;
use App\Http\Controllers\StockController;
use App\Http\Controllers\FeeController;
use App\Http\Controllers\SaleController;
use App\Http\Controllers\LedgerController;

// Redirect root to login
Route::get('/', function () {
    return redirect()->route('login');
});

// Authentication Routes
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

Route::get('/register', [RegisterController::class, 'showRegistrationForm'])->name('register');
Route::post('/register', [RegisterController::class, 'register']);

// Protected Routes (require authentication)
Route::middleware('auth')->group(function () {
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Students
    Route::resource('students', StudentController::class);
    Route::get('/students/print', [StudentController::class, 'print'])->name('students.print');
    Route::get('/students/{student}/print', [StudentController::class, 'printSingle'])->name('students.print-single');
    
    // Stock Management
    Route::get('/stock', [StockController::class, 'index'])->name('stock.index');
    Route::get('/stock/create', [StockController::class, 'create'])->name('stock.create');
    Route::post('/stock', [StockController::class, 'store'])->name('stock.store');
    Route::get('/stock/{stockItem:id}', [StockController::class, 'show'])->name('stock.show');
    Route::get('/stock/{stockItem:id}/edit', [StockController::class, 'edit'])->name('stock.edit');
    Route::put('/stock/{stockItem:id}', [StockController::class, 'update'])->name('stock.update');
    Route::delete('/stock/{stockItem:id}', [StockController::class, 'destroy'])->name('stock.destroy');
    Route::get('/stock-alerts', [StockController::class, 'alerts'])->name('stock.alerts');
    
    // Fees
    Route::get('/fees/collect', [FeeController::class, 'collect'])->name('fees.collect');
    Route::post('/fees/collect', [FeeController::class, 'store'])->name('fees.store');
    Route::get('/fees/history', [FeeController::class, 'history'])->name('fees.history');
    Route::get('/fees/outstanding', [FeeController::class, 'outstanding'])->name('fees.outstanding');
    
    // Sales
    Route::get('/sales/books', [SaleController::class, 'books'])->name('sales.books');
    Route::post('/sales/books', [SaleController::class, 'storeBook'])->name('sales.store-book');
    Route::get('/sales/uniforms', [SaleController::class, 'uniforms'])->name('sales.uniforms');
    Route::post('/sales/uniforms', [SaleController::class, 'storeUniform'])->name('sales.store-uniform');
    
    // Ledger
    Route::get('/ledger', [LedgerController::class, 'index'])->name('ledger.index');
    Route::get('/ledger/reports', [LedgerController::class, 'reports'])->name('ledger.reports');
});
