

<?php $__env->startSection('title', 'Student Details - The Smart School Education'); ?>
<?php $__env->startSection('page-title', 'Student Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <a href="<?php echo e(route('students.index')); ?>" class="text-blue-600 hover:text-blue-800 flex items-center">
        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
        </svg>
        Back to Students
    </a>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Student Information -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex justify-between items-start mb-6">
                <div>
                    <h2 class="text-2xl font-bold text-gray-900"><?php echo e($student->name); ?></h2>
                    <p class="text-gray-600">Admission #: <?php echo e($student->admission_number); ?></p>
                </div>
                <div class="flex gap-2">
                    <a href="<?php echo e(route('students.edit', $student)); ?>" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">
                        Edit
                    </a>
                    <form action="<?php echo e(route('students.destroy', $student)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this student?');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg">
                            Delete
                        </button>
                    </form>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="text-sm font-medium text-gray-500">Father's Name</label>
                    <p class="text-gray-900"><?php echo e($student->father_name ?? '-'); ?></p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Mother's Name</label>
                    <p class="text-gray-900"><?php echo e($student->mother_name ?? '-'); ?></p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Admission Date</label>
                    <p class="text-gray-900"><?php echo e($student->admission_date->format('d M Y')); ?></p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Date of Birth</label>
                    <p class="text-gray-900"><?php echo e($student->date_of_birth ? $student->date_of_birth->format('d M Y') : '-'); ?></p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Class</label>
                    <p class="text-gray-900">
                        <?php if($student->class): ?>
                            <?php echo e($student->class); ?><?php if($student->section): ?> - <?php echo e($student->section); ?><?php endif; ?>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Gender</label>
                    <p class="text-gray-900"><?php echo e(ucfirst($student->gender ?? '-')); ?></p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Phone</label>
                    <p class="text-gray-900"><?php echo e($student->phone ?? '-'); ?></p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Email</label>
                    <p class="text-gray-900"><?php echo e($student->email ?? '-'); ?></p>
                </div>
                <div class="md:col-span-2">
                    <label class="text-sm font-medium text-gray-500">Address</label>
                    <p class="text-gray-900"><?php echo e($student->address ?? '-'); ?></p>
                </div>
            </div>
        </div>

        <!-- Fee Payments -->
        <div class="bg-white rounded-lg shadow p-6 mt-6">
            <h3 class="text-lg font-semibold mb-4">Fee Payments</h3>
            <?php if($student->feePayments->count() > 0): ?>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Fee Type</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Receipt</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__currentLoopData = $student->feePayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="px-4 py-3 text-sm"><?php echo e($payment->payment_date->format('d M Y')); ?></td>
                            <td class="px-4 py-3 text-sm"><?php echo e($payment->feeType->name); ?></td>
                            <td class="px-4 py-3 text-sm font-medium">Rs. <?php echo e(number_format($payment->amount, 2)); ?></td>
                            <td class="px-4 py-3 text-sm"><?php echo e($payment->receipt_number ?? '-'); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <?php else: ?>
            <p class="text-gray-500 text-sm">No fee payments recorded yet.</p>
            <?php endif; ?>
        </div>
    </div>

    <!-- Sidebar Stats -->
    <div class="space-y-6">
        <!-- Summary Card -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold mb-4">Summary</h3>
            <div class="space-y-4">
                <div>
                    <label class="text-sm font-medium text-gray-500">Total Fees Paid</label>
                    <p class="text-2xl font-bold text-green-600">Rs. <?php echo e(number_format($student->total_fees_paid, 2)); ?></p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Outstanding Fees</label>
                    <p class="text-2xl font-bold text-red-600">Rs. <?php echo e(number_format($student->outstanding_fees, 2)); ?></p>
                </div>
            </div>
        </div>

        <!-- Book Purchases -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold mb-4">Book Purchases</h3>
            <?php if($student->bookPurchases->count() > 0): ?>
            <div class="space-y-2">
                <?php $__currentLoopData = $student->bookPurchases->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="text-sm">
                    <p class="font-medium"><?php echo e($purchase->stockItem->name); ?></p>
                    <p class="text-gray-600">Qty: <?php echo e($purchase->quantity); ?> × Rs. <?php echo e(number_format($purchase->unit_price, 2)); ?></p>
                    <p class="text-gray-500 text-xs"><?php echo e($purchase->purchase_date->format('d M Y')); ?></p>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php else: ?>
            <p class="text-gray-500 text-sm">No book purchases yet.</p>
            <?php endif; ?>
        </div>

        <!-- Uniform Purchases -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold mb-4">Uniform Purchases</h3>
            <?php if($student->uniformPurchases->count() > 0): ?>
            <div class="space-y-2">
                <?php $__currentLoopData = $student->uniformPurchases->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="text-sm">
                    <p class="font-medium"><?php echo e($purchase->stockItem->name); ?></p>
                    <p class="text-gray-600">Qty: <?php echo e($purchase->quantity); ?> × Rs. <?php echo e(number_format($purchase->unit_price, 2)); ?></p>
                    <p class="text-gray-500 text-xs"><?php echo e($purchase->purchase_date->format('d M Y')); ?></p>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php else: ?>
            <p class="text-gray-500 text-sm">No uniform purchases yet.</p>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\abdar\resources\views/students/show.blade.php ENDPATH**/ ?>