

<?php $__env->startSection('title', 'Outstanding Fees - The Smart School Education'); ?>
<?php $__env->startSection('page-title', 'Outstanding Fees'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <h2 class="text-xl font-semibold text-gray-800">Students with Outstanding Fees</h2>
    <p class="text-sm text-gray-600">Students who have pending fee payments</p>
</div>

<?php if($students->count() > 0): ?>
<div class="bg-white rounded-lg shadow overflow-hidden">
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Admission #</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Name</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Class</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Total Due</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Paid</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Outstanding</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3 text-sm font-medium text-gray-900"><?php echo e($student->admission_number); ?></td>
                    <td class="px-4 py-3 text-sm text-gray-900"><?php echo e($student->name); ?></td>
                    <td class="px-4 py-3 text-sm text-gray-500"><?php echo e($student->class ?? '-'); ?></td>
                    <td class="px-4 py-3 text-sm text-right text-gray-600">
                        Rs. <?php echo e(number_format($student->admission_form + $student->monthly_fees + $student->annual_charges, 2)); ?>

                    </td>
                    <td class="px-4 py-3 text-sm text-right text-green-600">
                        Rs. <?php echo e(number_format($student->total_fees_paid, 2)); ?>

                    </td>
                    <td class="px-4 py-3 text-sm text-right font-bold text-red-600">
                        Rs. <?php echo e(number_format($student->outstanding_amount, 2)); ?>

                    </td>
                    <td class="px-4 py-3 text-right text-sm font-medium">
                        <a href="<?php echo e(route('fees.collect')); ?>?student_id=<?php echo e($student->id); ?>" class="text-blue-600 hover:text-blue-900">
                            Collect Fee
                        </a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot class="bg-gray-50">
                <tr>
                    <td colspan="5" class="px-4 py-3 text-sm font-bold text-right">Total Outstanding:</td>
                    <td class="px-4 py-3 text-sm font-bold text-right text-red-600">
                        Rs. <?php echo e(number_format($students->sum('outstanding_amount'), 2)); ?>

                    </td>
                    <td></td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
<?php else: ?>
<div class="bg-green-50 border-l-4 border-green-500 p-4">
    <p class="text-sm text-green-700">
        <strong>Great!</strong> No outstanding fees. All students have paid their dues.
    </p>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\abdar\resources\views/fees/outstanding.blade.php ENDPATH**/ ?>