

<?php $__env->startSection('title', 'Fee History - The Smart School Education'); ?>
<?php $__env->startSection('page-title', 'Fee Payment History'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <h2 class="text-xl font-semibold text-gray-800">Fee Payment History</h2>
</div>

<!-- Filters -->
<div class="bg-white rounded-lg shadow p-4 mb-6">
    <form method="GET" action="<?php echo e(route('fees.history')); ?>" class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <select name="student_id" class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
            <option value="">All Students</option>
            <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($student->id); ?>" <?php echo e(request('student_id') == $student->id ? 'selected' : ''); ?>>
                <?php echo e($student->admission_number); ?> - <?php echo e($student->name); ?>

            </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <input type="date" name="from_date" value="<?php echo e(request('from_date')); ?>" 
               placeholder="From Date" 
               class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
        <input type="date" name="to_date" value="<?php echo e(request('to_date')); ?>" 
               placeholder="To Date" 
               class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
        <div class="flex gap-2">
            <button type="submit" class="flex-1 bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                Filter
            </button>
            <?php if(request()->anyFilled(['student_id', 'from_date', 'to_date'])): ?>
            <a href="<?php echo e(route('fees.history')); ?>" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-lg">
                Clear
            </a>
            <?php endif; ?>
        </div>
    </form>
</div>

<!-- Payments Table -->
<div class="bg-white rounded-lg shadow overflow-hidden">
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Fee Type</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Payment Method</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Receipt #</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3 text-sm text-gray-900"><?php echo e($payment->payment_date->format('d M Y')); ?></td>
                    <td class="px-4 py-3 text-sm text-gray-900">
                        <?php echo e($payment->student->admission_number); ?> - <?php echo e($payment->student->name); ?>

                    </td>
                    <td class="px-4 py-3 text-sm text-gray-600"><?php echo e($payment->feeType->name ?? 'N/A'); ?></td>
                    <td class="px-4 py-3 text-sm text-right font-medium text-green-600">
                        Rs. <?php echo e(number_format($payment->amount, 2)); ?>

                    </td>
                    <td class="px-4 py-3 text-sm text-gray-500">
                        <?php echo e(ucfirst(str_replace('_', ' ', $payment->payment_method))); ?>

                    </td>
                    <td class="px-4 py-3 text-sm text-gray-500"><?php echo e($payment->receipt_number ?? '-'); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="px-6 py-4 text-center text-sm text-gray-500">
                        No fee payments found.
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if($payments->hasPages()): ?>
    <div class="bg-gray-50 px-4 py-3 border-t border-gray-200">
        <?php echo e($payments->links()); ?>

    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\abdar\resources\views/fees/history.blade.php ENDPATH**/ ?>