<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Details - The Smart School Education</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        @media print {
            @page {
                size: A4;
                margin: 8mm;
            }
            body {
                margin: 0;
                padding: 0;
            }
            .no-print {
                display: none !important;
            }
        }
        body {
            font-family: 'Arial', 'Helvetica', sans-serif;
            font-size: 12px;
            line-height: 1.5;
            margin: 0;
            padding: 20px;
            color: #000;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 3px solid #000;
            padding-bottom: 12px;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: bold;
            letter-spacing: 1px;
            color: #000;
        }
        .header p {
            margin: 5px 0;
            font-size: 14px;
            font-weight: 500;
        }
        .student-info {
            margin: 20px 0;
            background-color: #f9f9f9;
            padding: 15px;
            border: 1px solid #ddd;
        }
        .info-row {
            display: flex;
            margin: 10px 0;
            border-bottom: 1px dotted #999;
            padding: 6px 0;
            font-size: 12px;
        }
        .info-row:last-child {
            border-bottom: none;
        }
        .info-label {
            font-weight: bold;
            width: 200px;
            color: #333;
        }
        .info-value {
            flex: 1;
            color: #000;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
            font-size: 11px;
        }
        th, td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #e8e8e8;
            font-weight: bold;
            text-align: center;
            font-size: 11px;
            padding: 10px 8px;
        }
        td {
            font-size: 10px;
            padding: 7px 8px;
        }
        tbody tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .text-right {
            text-align: right;
            font-weight: 500;
        }
        .text-center {
            text-align: center;
        }
        .summary-box {
            margin-top: 20px;
            padding: 18px;
            border: 2px solid #000;
            background-color: #f5f5f5;
        }
        .summary-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            font-size: 12px;
            border-bottom: 1px dotted #666;
        }
        .summary-row:last-child {
            border-bottom: none;
        }
        .summary-row.total {
            border-top: 2px solid #000;
            margin-top: 10px;
            padding-top: 12px;
            font-weight: bold;
            font-size: 14px;
        }
        .footer {
            margin-top: 30px;
            padding-top: 12px;
            border-top: 2px solid #000;
            text-align: center;
            font-size: 10px;
            font-weight: 500;
        }
        .print-btn {
            text-align: center;
            margin: 20px 0;
        }
        .print-btn button {
            background-color: #4CAF50;
            color: white;
            padding: 12px 35px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            font-family: 'Arial', sans-serif;
        }
        .print-btn button:hover {
            background-color: #45a049;
        }
        h3 {
            font-size: 14px;
            font-weight: bold;
            margin-top: 25px;
            border-bottom: 2px solid #000;
            padding-bottom: 8px;
            color: #000;
        }
    </style>
</head>
<body>
    <div class="print-btn no-print">
        <button onclick="window.print()">🖨️ Print</button>
    </div>

    <div class="header">
        <h1>THE SMART SCHOOL EDUCATION</h1>
        <p>Student Details</p>
        <p>Date: <?php echo e(date('d M Y, h:i A')); ?></p>
    </div>

    <div class="student-info">
        <div class="info-row">
            <div class="info-label">Admission Number:</div>
            <div class="info-value"><?php echo e($student->admission_number); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">Student Name:</div>
            <div class="info-value"><strong><?php echo e($student->name); ?></strong></div>
        </div>
        <div class="info-row">
            <div class="info-label">Father's Name:</div>
            <div class="info-value"><?php echo e($student->father_name ?? '-'); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">Class:</div>
            <div class="info-value"><?php echo e($student->class ?? '-'); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">Admission Date:</div>
            <div class="info-value"><?php echo e($student->admission_date->format('d M Y')); ?></div>
        </div>
        <?php if($student->remarks): ?>
        <div class="info-row">
            <div class="info-label">Remarks:</div>
            <div class="info-value"><?php echo e($student->remarks); ?></div>
        </div>
        <?php endif; ?>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 20%;">Fee Type</th>
                <th style="width: 15%;">Amount (Rs.)</th>
                <th style="width: 15%;">Paid (Rs.)</th>
                <th style="width: 15%;">Balance (Rs.)</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>Admission Form</td>
                <td class="text-right"><?php echo e(number_format($student->admission_form, 2)); ?></td>
                <td class="text-right"><?php echo e(number_format($student->feePayments->where('feeType.name', 'Admission Fee')->sum('amount') ?? 0, 2)); ?></td>
                <td class="text-right"><?php echo e(number_format(max(0, $student->admission_form - ($student->feePayments->where('feeType.name', 'Admission Fee')->sum('amount') ?? 0)), 2)); ?></td>
            </tr>
            <tr>
                <td>Monthly Fees</td>
                <td class="text-right"><?php echo e(number_format($student->monthly_fees, 2)); ?></td>
                <td class="text-right"><?php echo e(number_format($student->feePayments->where('feeType.name', 'Monthly Fee')->sum('amount') ?? 0, 2)); ?></td>
                <td class="text-right"><?php echo e(number_format(max(0, $student->monthly_fees - ($student->feePayments->where('feeType.name', 'Monthly Fee')->sum('amount') ?? 0)), 2)); ?></td>
            </tr>
            <tr>
                <td>Annual Charges</td>
                <td class="text-right"><?php echo e(number_format($student->annual_charges, 2)); ?></td>
                <td class="text-right"><?php echo e(number_format($student->feePayments->where('feeType.name', 'Annual Charges')->sum('amount') ?? 0, 2)); ?></td>
                <td class="text-right"><?php echo e(number_format(max(0, $student->annual_charges - ($student->feePayments->where('feeType.name', 'Annual Charges')->sum('amount') ?? 0)), 2)); ?></td>
            </tr>
        </tbody>
    </table>

    <div class="summary-box">
        <div class="summary-row">
            <strong>Total Fees Due:</strong>
            <strong>Rs. <?php echo e(number_format($student->admission_form + $student->monthly_fees + $student->annual_charges, 2)); ?></strong>
        </div>
        <div class="summary-row">
            <strong>Total Fees Paid:</strong>
            <strong>Rs. <?php echo e(number_format($student->total_fees_paid, 2)); ?></strong>
        </div>
        <div class="summary-row">
            <strong>Uniform Purchases:</strong>
            <strong>Rs. <?php echo e(number_format($student->uniform_total, 2)); ?></strong>
        </div>
        <div class="summary-row">
            <strong>Books/Copies Purchases:</strong>
            <strong>Rs. <?php echo e(number_format($student->books_copies_total, 2)); ?></strong>
        </div>
        <div class="summary-row total">
            <strong>Total Arrears (Outstanding):</strong>
            <strong>Rs. <?php echo e(number_format($student->arrears, 2)); ?></strong>
        </div>
    </div>

    <?php if($student->feePayments->count() > 0): ?>
    <h3>Fee Payment History</h3>
    <table style="margin-top: 10px;">
        <thead>
            <tr>
                <th style="width: 15%;">Date</th>
                <th style="width: 25%;">Fee Type</th>
                <th style="width: 15%;">Amount (Rs.)</th>
                <th style="width: 20%;">Payment Method</th>
                <th style="width: 25%;">Receipt Number</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $student->feePayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($payment->payment_date->format('d M Y')); ?></td>
                <td><?php echo e($payment->feeType->name ?? 'N/A'); ?></td>
                <td class="text-right"><?php echo e(number_format($payment->amount, 2)); ?></td>
                <td class="text-center"><?php echo e(ucfirst(str_replace('_', ' ', $payment->payment_method))); ?></td>
                <td><?php echo e($payment->receipt_number ?? '-'); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <?php endif; ?>

    <div class="footer">
        <p>Generated on <?php echo e(date('d M Y, h:i A')); ?> | The Smart School Education</p>
        <p>This is a computer generated document.</p>
    </div>

    <script>
        window.onload = function() {
            // Auto print when page loads (optional - you can remove this if you want manual print)
            // window.print();
        }
    </script>
</body>
</html>

<?php /**PATH D:\abdar\resources\views/students/print-single.blade.php ENDPATH**/ ?>