<!-- Mobile Overlay -->
<div id="sidebar-overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-30 hidden lg:hidden" onclick="toggleSidebar()"></div>

<!-- Sidebar -->
<aside class="fixed left-0 top-0 z-40 h-screen w-64 bg-blue-800 text-white transition-transform duration-300 ease-in-out -translate-x-full lg:translate-x-0" id="sidebar">
    <div class="flex h-full flex-col">
        <!-- Logo/Header -->
        <div class="flex h-16 items-center justify-between border-b border-blue-700 px-3">
            <h2 class="text-sm font-bold leading-tight">The Smart School Education</h2>
            <!-- Mobile Close Button -->
            <button onclick="toggleSidebar()" class="lg:hidden p-2 rounded-md text-white hover:bg-blue-700 focus:outline-none flex-shrink-0">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>

        <!-- Navigation Menu -->
        <nav class="flex-1 space-y-1 overflow-y-auto px-3 py-4">
            <!-- Dashboard -->
            <a href="<?php echo e(route('dashboard')); ?>" onclick="closeSidebarOnMobile()" class="flex items-center rounded-lg px-4 py-3 text-sm font-medium transition-colors hover:bg-blue-700 <?php echo e(request()->routeIs('dashboard') ? 'bg-blue-700' : ''); ?>">
                <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                </svg>
                Dashboard
            </a>

            <!-- Students -->
            <a href="<?php echo e(route('students.index')); ?>" onclick="closeSidebarOnMobile()" class="flex items-center rounded-lg px-4 py-3 text-sm font-medium transition-colors hover:bg-blue-700 <?php echo e(request()->routeIs('students.*') ? 'bg-blue-700' : ''); ?>">
                <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                </svg>
                Students
            </a>

            <!-- Stock Management -->
            <div class="space-y-1">
                <button onclick="toggleDropdown('stock-menu')" class="w-full flex items-center rounded-lg px-4 py-3 text-sm font-medium transition-colors hover:bg-blue-700 <?php echo e(request()->routeIs('stock.*') ? 'bg-blue-700' : ''); ?>">
                    <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                    </svg>
                    Stock Management
                    <svg id="stock-arrow" class="ml-auto h-4 w-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <div id="stock-menu" class="ml-8 space-y-1 <?php echo e(request()->routeIs('stock.*') ? '' : 'hidden'); ?>">
                    <a href="<?php echo e(route('stock.index')); ?>" onclick="closeSidebarOnMobile()" class="block rounded-lg px-4 py-2 text-sm transition-colors hover:bg-blue-700 <?php echo e(request()->routeIs('stock.index') ? 'bg-blue-700' : ''); ?>">
                        View Stock
                    </a>
                    <a href="<?php echo e(route('stock.create')); ?>" onclick="closeSidebarOnMobile()" class="block rounded-lg px-4 py-2 text-sm transition-colors hover:bg-blue-700 <?php echo e(request()->routeIs('stock.create') ? 'bg-blue-700' : ''); ?>">
                        Add Stock
                    </a>
                    <a href="<?php echo e(route('stock.alerts')); ?>" onclick="closeSidebarOnMobile()" class="block rounded-lg px-4 py-2 text-sm transition-colors hover:bg-blue-700 <?php echo e(request()->routeIs('stock.alerts') ? 'bg-blue-700' : ''); ?>">
                        Stock Alerts
                    </a>
                </div>
            </div>

            <!-- Fees -->
            <div class="space-y-1">
                <button onclick="toggleDropdown('fees-menu')" class="w-full flex items-center rounded-lg px-4 py-3 text-sm font-medium transition-colors hover:bg-blue-700 <?php echo e(request()->routeIs('fees.*') ? 'bg-blue-700' : ''); ?>">
                    <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    Fees
                    <svg id="fees-arrow" class="ml-auto h-4 w-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <div id="fees-menu" class="ml-8 space-y-1 <?php echo e(request()->routeIs('fees.*') ? '' : 'hidden'); ?>">
                    <a href="<?php echo e(route('fees.collect')); ?>" onclick="closeSidebarOnMobile()" class="block rounded-lg px-4 py-2 text-sm transition-colors hover:bg-blue-700 <?php echo e(request()->routeIs('fees.collect') || request()->routeIs('fees.store') ? 'bg-blue-700' : ''); ?>">
                        Collect Fee
                    </a>
                    <a href="<?php echo e(route('fees.history')); ?>" onclick="closeSidebarOnMobile()" class="block rounded-lg px-4 py-2 text-sm transition-colors hover:bg-blue-700 <?php echo e(request()->routeIs('fees.history') ? 'bg-blue-700' : ''); ?>">
                        Fee History
                    </a>
                    <a href="<?php echo e(route('fees.outstanding')); ?>" onclick="closeSidebarOnMobile()" class="block rounded-lg px-4 py-2 text-sm transition-colors hover:bg-blue-700 <?php echo e(request()->routeIs('fees.outstanding') ? 'bg-blue-700' : ''); ?>">
                        Outstanding Fees
                    </a>
                </div>
            </div>

            <!-- Sales -->
            <div class="space-y-1">
                <button onclick="toggleDropdown('sales-menu')" class="w-full flex items-center rounded-lg px-4 py-3 text-sm font-medium transition-colors hover:bg-blue-700 <?php echo e(request()->routeIs('sales.*') ? 'bg-blue-700' : ''); ?>">
                    <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                    </svg>
                    Sales
                    <svg id="sales-arrow" class="ml-auto h-4 w-4 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <div id="sales-menu" class="ml-8 space-y-1 <?php echo e(request()->routeIs('sales.*') ? '' : 'hidden'); ?>">
                    <a href="<?php echo e(route('sales.books')); ?>" onclick="closeSidebarOnMobile()" class="block rounded-lg px-4 py-2 text-sm transition-colors hover:bg-blue-700 <?php echo e(request()->routeIs('sales.books') || request()->routeIs('sales.store-book') ? 'bg-blue-700' : ''); ?>">
                        Book Sales
                    </a>
                    <a href="<?php echo e(route('sales.uniforms')); ?>" onclick="closeSidebarOnMobile()" class="block rounded-lg px-4 py-2 text-sm transition-colors hover:bg-blue-700 <?php echo e(request()->routeIs('sales.uniforms') || request()->routeIs('sales.store-uniform') ? 'bg-blue-700' : ''); ?>">
                        Uniform Sales
                    </a>
                </div>
            </div>

            <!-- Ledger -->
            <a href="<?php echo e(route('ledger.index')); ?>" onclick="closeSidebarOnMobile()" class="flex items-center rounded-lg px-4 py-3 text-sm font-medium transition-colors hover:bg-blue-700 <?php echo e(request()->routeIs('ledger.index') ? 'bg-blue-700' : ''); ?>">
                <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                Ledger (Hesab Kitab)
            </a>

            <!-- Reports -->
            <a href="<?php echo e(route('ledger.reports')); ?>" onclick="closeSidebarOnMobile()" class="flex items-center rounded-lg px-4 py-3 text-sm font-medium transition-colors hover:bg-blue-700 <?php echo e(request()->routeIs('ledger.reports') ? 'bg-blue-700' : ''); ?>">
                <svg class="mr-3 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                Reports
            </a>
        </nav>

        <!-- User Section -->
        <div class="border-t border-blue-700 p-4">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="flex h-10 w-10 items-center justify-center rounded-full bg-blue-700">
                        <span class="text-sm font-medium"><?php echo e(substr(Auth::user()->name, 0, 1)); ?></span>
                    </div>
                </div>
                <div class="ml-3 flex-1">
                    <p class="text-sm font-medium"><?php echo e(Auth::user()->name); ?></p>
                    <p class="text-xs text-blue-300">Accountant</p>
                </div>
            </div>
            <form method="POST" action="<?php echo e(route('logout')); ?>" class="mt-3">
                <?php echo csrf_field(); ?>
                <button type="submit" class="w-full rounded-lg bg-blue-700 px-4 py-2 text-sm font-medium transition-colors hover:bg-blue-600">
                    Logout
                </button>
            </form>
        </div>
    </div>
</aside>

<script>
function toggleDropdown(menuId) {
    const menu = document.getElementById(menuId);
    const arrowId = menuId.replace('-menu', '-arrow');
    const arrow = document.getElementById(arrowId);
    
    if (menu.classList.contains('hidden')) {
        menu.classList.remove('hidden');
        if (arrow) {
            arrow.style.transform = 'rotate(180deg)';
        }
    } else {
        menu.classList.add('hidden');
        if (arrow) {
            arrow.style.transform = 'rotate(0deg)';
        }
    }
}

// Auto-expand menus if on that route
document.addEventListener('DOMContentLoaded', function() {
    <?php if(request()->routeIs('stock.*')): ?>
        const stockMenu = document.getElementById('stock-menu');
        const stockArrow = document.getElementById('stock-arrow');
        if (stockMenu) stockMenu.classList.remove('hidden');
        if (stockArrow) stockArrow.style.transform = 'rotate(180deg)';
    <?php endif; ?>
    
    <?php if(request()->routeIs('fees.*')): ?>
        const feesMenu = document.getElementById('fees-menu');
        const feesArrow = document.getElementById('fees-arrow');
        if (feesMenu) feesMenu.classList.remove('hidden');
        if (feesArrow) feesArrow.style.transform = 'rotate(180deg)';
    <?php endif; ?>
    
    <?php if(request()->routeIs('sales.*')): ?>
        const salesMenu = document.getElementById('sales-menu');
        const salesArrow = document.getElementById('sales-arrow');
        if (salesMenu) salesMenu.classList.remove('hidden');
        if (salesArrow) salesArrow.style.transform = 'rotate(180deg)';
    <?php endif; ?>
});
</script>

<?php /**PATH D:\abdar\resources\views/components/sidebar.blade.php ENDPATH**/ ?>